﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using DAL;



    [DataObject]
    public class HospitalManager
    {
        [DataObjectMethod(DataObjectMethodType.Select)]
        public List<HospitalStaff> GetDoctors()
        {
            using (var staffCtx = new HospitalDataContext())
            {
                return
                    (from staff in staffCtx.HospitalStaffs
                     where staff.Position == "Lekarz"
                     select staff)
                     .ToList();
            }
        }

        private List<string> positions = new List<string>
        {
            "Lekarz", "Pielęgniarka", "Stażysta1", "Stażysta2"
        };

        [DataObjectMethod(DataObjectMethodType.Insert)]
        public void AddStaff(string name, string position)
        {
            if (!positions.Contains(position))
            {
                throw new ArgumentException("Niewłaściwe stanowisko!", "position");
            }

            using (var staffCtx = new HospitalDataContext())
            {
                staffCtx
                    .HospitalStaffs
                    .InsertOnSubmit
                    (
                        new HospitalStaff
                        {
                            Name = name,
                            Position = position
                        }
                    );

                staffCtx.SubmitChanges();
            }
        }
    }

